function [Data,T_VEC,ChanDelays]=STM32F411_ADC_PLOT_DE_ICE(skt,n,rep,FSig)
%
%function [Data,T_VEC,ChanDelays]=STM32F411_ADC_PLOT(skt,n,rep)
%
% Get Data and optionally plot from an STM32F411 board with peek poke
%  skt           : peek poke udp skt structure
%  n             : number of sample frames per plot
%  rep           : number of plots to get
%                : if rep=0 then get 1 plot of data - do not plot
%
%  Data          : output data of last plot captured
%  T_VEC         : time vector of last frame captured - (Secs)
%  ChanDelays    : vector of dhannel delays relative to 1st channel   (Secs)
%
% See Also STM32F411_ADC_SETUP.m
%
%   Ian Stothers Feb 2021
%
%   To Do
%

STM32F411_bitfields; % Get some bitfields

bpe=[1 2 4 4](1+bitand(floor(udpget(skt,"DMA2_S0_CR")/(2^13)),3));  % Bytes per element from the DMA engine  
SQR1=udpget(skt,"ADC1_SQR1");
nchan = bitand(floor(SQR1/2^20),15)+1;           % Number of Channels from the ADC engine
DMABUF_ADDR=skt.ptr(skt_find_index(skt,"ADC_DMA_Buffer"));          % DMA buffer address from the registry
msdma=skt.len(skt_find_index(skt,"ADC_DMA_Buffer"))/bpe;            % DMA buffer size in bpe lumps from the registry
FT_Clock=udpget(skt,"SystemCoreClock");                             % Read Core Clock rate from registry
T2_PSC=udpget(skt,"TIM2_PSC");                                      % Read T2 presclaer from registry
T2_ARR=udpget(skt,"TIM2_ARR");                                      % Read T2 Period (ARR) Reg from registry

DT=((T2_PSC+1.0)*(T2_ARR+1.0))/FT_Clock;
Fs=1/DT;
SAMP_CONST=bitand(udpget(skt,"ADC1_SMPR1"),7);
ADC_PR=bitand(ADC_PRE,udpget(skt,"ADC1_COMMON_CCR"))/ADC_PRE;
CR1=udpget(skt,"ADC1_CR1");
RES_VAL=bitand(CR1,RES*3)/RES;
SampCycles=[3 15 28 56 84 112 144 480]; % lookup for SampCycles(SAMP_CONST+1)
%ChanDelays=((1:nchan)-1)*((3+SampCycles(SAMP_CONST+1)+(15-2*RES_VAL))*(2+(2*(ADC_PR))))/FT_Clock;
%FT_Clock
%ADC_PR  
%RES_VAL
%SAMP_CONST  
ResSamples=[ 15 13 11 9];
ChanDelays=((1:nchan)-1)*(3+SampCycles(SAMP_CONST+1)+ResSamples(RES_VAL+1))*(2+(2*ADC_PR))/FT_Clock;

T_VEC=((1:n)-1)*DT;
T_VEC=ones(nchan,1)*T_VEC+(ChanDelays')*ones(1,size(T_VEC)(2));
%T_VEC=ones(nchan,1)*T_VEC+ChanDelays'*ones(1,size(T_VEC)(2));


s_of_dma=floor(msdma/nchan)*nchan;                                  % ensure dma is shrunk to contain integer number of frames to keep channel alignment
n=n*nchan; % total number of samples to get
for fr=1:max([1 rep]) 
 tail=(s_of_dma-(ceil(udpget(skt,"DMA2_S0_NDTR")/nchan)*nchan));
 Data=[];
 N=0;
 while (N<n)
  ptr=(s_of_dma-(ceil(udpget(skt,"DMA2_S0_NDTR")/nchan)*nchan));
  if (tail>ptr)
   toget=min(s_of_dma-tail,n-N); 
   data=udppeek(skt,DMABUF_ADDR+(tail*bpe),toget*bpe);
   Data=[Data data];
   N=N+toget;
   tail=tail+toget; 
   if (tail>=s_of_dma) tail=0; end 
  end 
  if ((ptr>tail)&&(N<n)) 
   toget=min(ptr-tail,n-N); 
   data=udppeek(skt,DMABUF_ADDR+(tail*bpe),toget*bpe);
   Data=[Data data];
   N=N+toget;
   tail=tail+toget;
   end
 endwhile
 
 Data=udpgettconv(Data,[0 2](bpe),nchan); % 0 is uint8  2 is uint16
 
  if (rep>0)
  hold off
  plot(T_VEC',Data');
  xlabel("Time (Secs)");
  grid on;
  drawnow;
 endif
end 
   

  
 


  
  
  